<?php
/* --------------------------------------------------------------
  PublishedThemeRemover.php 2019-12-12
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

/**
 * Class PublishedThemeRemover
 */
class PublishedThemeRemover implements PublishedThemeRemoverInterface
{
    /**
     * @var FilesystemAdapter
     */
    protected $filesystem;
    
    /**
     * @var ShopPathsInterface
     */
    protected $shopPaths;
    
    
    /**
     * PublishedThemeRemover constructor.
     *
     * @param FilesystemAdapter  $filesystem
     * @param ShopPathsInterface $shopPaths
     */
    public function __construct(FilesystemAdapter $filesystem, ShopPathsInterface $shopPaths)
    {
        $this->filesystem = $filesystem;
        $this->shopPaths  = $shopPaths;
    }
    
    
    public function removePublishedTheme(): void
    {
        $publishedThemePath = $this->shopPaths->publishedThemePath();
        
        if ($this->filesystem->has($publishedThemePath)) {
            
            $this->filesystem->deleteDir($publishedThemePath);
        }
        
        $this->filesystem->createDir($publishedThemePath);
        clearstatcache();
    }
}